/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.jei.sieve;

import com.google.common.collect.HashMultiset;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import novamachina.exnihilosequentia.common.compat.jei.sieve.JEISieveRecipe;
import novamachina.exnihilosequentia.common.crafting.sieve.MeshWithChance;
import novamachina.exnihilosequentia.common.crafting.sieve.SieveRecipe;
import novamachina.exnihilosequentia.common.item.MeshItem;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.utility.StringUtils;

public class SieveTooltipCallback
implements IRecipeSlotTooltipCallback {
    private final JEISieveRecipe recipe;
    private final boolean isWaterlogged;

    public SieveTooltipCallback(JEISieveRecipe recipe, boolean isWaterlogged) {
        this.recipe = recipe;
        this.isWaterlogged = isWaterlogged;
    }

    public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
        if (recipeSlotView.getRole() == RecipeIngredientRole.OUTPUT) {
            HashMultiset condensedTooltips = HashMultiset.create();
            List<SieveRecipe> drops = ExNihiloRegistries.SIEVE_REGISTRY.getDrops((ItemLike)this.recipe.getInputs().get(1).get(0).m_41720_(), ((MeshItem)this.recipe.getInputs().get(0).get(0).m_41720_()).getType(), this.isWaterlogged);
            for (SieveRecipe entry : drops) {
                ItemStack drop = entry.getDrop();
                Optional optional = recipeSlotView.getDisplayedIngredient();
                if (optional.isEmpty() || !drop.m_41656_((ItemStack)((ITypedIngredient)optional.get()).getIngredient())) continue;
                for (MeshWithChance meshWithChance : entry.getRolls()) {
                    condensedTooltips.add((Object)StringUtils.formatPercent(Float.valueOf(meshWithChance.getChance())));
                }
            }
            tooltip.add((Component)new TranslatableComponent("jei.sieve.dropChance"));
            for (String line : condensedTooltips.elementSet()) {
                tooltip.add((Component)new TextComponent(" * " + condensedTooltips.count((Object)line) + "x " + line));
            }
        }
    }
}

